<?php
namespace model;

class Control extends \Pawn\Model
{
	// Migration
	public static function migration()
	{
		return array
		(
			array('CREATE', array
			(
				'game_id'	=>	'INT UNSIGNED',
				'action'	=>	'VARCHAR(64)',
				'key'		=>	'VARCHAR(64)'
			))
		);
	}
	
	// Validation
	public function columns()
	{
		return array
		(
			'game_id'	=>	array('text', array('c_game_exists'=>array($this, 'game_exists'))),
			'action'	=>	array('text', array()),
			'key'		=>	array('text', array())
		);
	}
	
	public function game_exists($id)
	{
		return \model\Game::num_rows('WHERE id=?', $id, false);
	}
}